(*| 23:19 15/09/1995 *)
PROGRAM ENTAB;

USES Crt,Dos;

TYPE
  FNameType= STRING[12];
  LineString= STRING[80];
  MaxString= STRING[255];

VAR
  ChosenDrive,ThisFileName,FileExt: FNameType;
  FindRec: SearchRec;
  ByteFile: FILE OF Byte;
  FileSpec,OptionString,OriginalPath,CurrentPath,TextLine: LineString;
  I,DriveNum: Integer;
  Abort,OldDate,NewFile,Modified,DeTab: Boolean;
  C:Char;

FUNCTION IntToString(Num, Width : Integer) : LineString;
{ Changes an integer into a string }
VAR TempString : LineString;
BEGIN
  Str(Num:Width, TempString);
  IntToString := TempString;
END; { IntToString }

FUNCTION IntToPadString(Num, Width : Integer) : LineString;
{ Changes an integer into a string and pads it with a zero on the left if
  it is less than 10 }
BEGIN
  IF Num < 10 THEN
    IntToPadString := '0' + IntToString(Num, Width)
  ELSE
    IntToPadString := IntToString(Num, Width);
END; { IntToString }

FUNCTION RealToString(Num : Real; Width, Places : Integer) : LineString;
{ Changes a real number into a string }
VAR TempString : LineString;
BEGIN
  Str(Num:Width:Places, TempString);
  RealToString := TempString;
END; { RealToString }

{ ==================== GENERAL PURPOSE STRING ROUTINES ====================== }
FUNCTION FixString(FString : LineString; Len : Byte) : LineString;
{ Makes a string a specified length.  If the string is too long, the extra
  characters will be truncated.  If the string is too short, the string will
  be padded with spaces.
}
var StringLen : byte absolute FString;
                            { Make a variable for FString's length byte }
BEGIN
  IF StringLen > Len THEN
    Delete(FString, Succ(Len), StringLen - Len)
                                    { Delete end of string if it is too long }
  ELSE
    WHILE StringLen < Len DO          { Pad FString with spaces on the right }
      FString := FString + ' ';
  FixString := FString;
END; { FixString }

FUNCTION UpperCase(S : LineString) : LineString;
{ Convert a string to all upper case letters }
VAR I : integer;
BEGIN                               { Note that we intentionally modify a    }
  FOR I := 1 to LENGTH(S) DO        { VALUE parameter, and then return that  }
    S[I] := UpCase(S[I]);           { modified value via the function value. }
  UpperCase := S;
END; { UpperCase }

FUNCTION FileDateString(Date :DateTime):LineString;
BEGIN
  WITH Date DO
    FileDateString:=IntToString(Day,2) + '/' +
                    IntToPadString(Month,1) + '/' +
                    IntToString(Year,4);
END;

FUNCTION FileTimeString(Time :DateTime):LineString;
BEGIN
  WITH Time DO
    FileTimeString:=IntToString(Hour,2) + ':' +
                    IntToPadString(Min,1);
END;

PROCEDURE ShowHelp;
BEGIN
  Writeln('Usage    : ENTAB [D:][filespec]');
  Writeln('           Default filespec *.ASM');
  Writeln('Switches : /D    file Date updated');
  Writeln('           /N    new file, .NEW');
  Writeln('           /U    untabulate');
  HALT;
END;  { ShowHelp }

PROCEDURE ProcessOptions;
BEGIN
  OldDate:=True;
  NewFile:=False;
  DeTab:=False;
  IF POS('/D',OptionString) > 0 THEN OldDate:=False;
  IF POS('/N',OptionString) > 0 THEN NewFile:=True;
  IF POS('/U',OptionString) > 0 THEN DeTab:=True;
END; { ProcessOptions }

PROCEDURE DeTabThisLine(VAR ThisLine:MaxString);
VAR
  I,J,K: Integer;
  Spaces: STRING[8];
BEGIN
  I:=0;
  WHILE I < Length(ThisLine) DO BEGIN
    INC(I);
    IF ThisLine[I] = #9 THEN BEGIN
      ThisLine[I]:=' ';
      J:= I AND $07;
      IF J > 0 THEN BEGIN
        J:= 8-J;
        IF J > 0 THEN BEGIN
          Spaces:='';
          FOR K:=1 TO J DO
            Spaces:=Spaces + ' ';
          INSERT(Spaces,ThisLine,I);
          I:=I+J;
        END;
      END;
    END;
  END;
END;  { DeTabThisLine }

PROCEDURE EnTabThisLine(VAR ThisLine:MaxString);
VAR
  I,L: Integer;
  OldLine: MaxString;
BEGIN
  OldLine:=ThisLine;
  L:=Length(ThisLine);
  IF (L > 1) AND (POS('  ',ThisLine) > 0) THEN BEGIN
    IF POS(#9,ThisLine) > 0 THEN BEGIN
      DeTabThisLine(ThisLine);
      L:=Length(ThisLine);
    END ELSE IF L < 9 THEN EXIT;
    L:=L AND $F8;
    WHILE L > 0 DO BEGIN
      IF (ThisLine[L]=' ') AND (ThisLine[L-1]=' ') THEN BEGIN
        ThisLine[L]:=#9;
        I:=L-1;
        WHILE (ThisLine[I-1]=' ') AND (I > l-7) DO BEGIN
          DEC(I);
        END;
        DELETE(ThisLine,I,L-I);
        Modified:=(OldLine <> ThisLine);
      END;
      L:=L-8;
    END;
  END;
END; { EnTabThisLine }

PROCEDURE DoEnTab(FName:FNameType);

VAR
  SrcFile,DestFile: TEXT;
  DFName: FNameType;
  FileTime: LongInt;
  CopyLine: MaxString;
BEGIN
  Modified:=False;
  IF NewFile THEN
    DFName:=COPY(FName,1,POS('.',FName))+'NEW'
  ELSE
    DFName:=COPY(FName,1,POS('.',FName))+'$$$';
  Assign(SrcFile,FName);
  Reset(SrcFile);
  GetFTime(SrcFile,FileTime);
  Assign(DestFile,DFName);
  Rewrite(DestFile);
  WHILE NOT EOF(SrcFile) DO BEGIN
    Readln(SrcFile,CopyLine);
    IF DeTab THEN
      DeTabThisLine(CopyLine)
    ELSE
      EnTabThisLine(CopyLine);
    Writeln(DestFile,CopyLine);
  END;
  Close(SrcFile);
  {$I-}
  Close(DestFile);
  {$I+}
  IF IOResult = 0 THEN
    BEGIN
      Reset(DestFile);
      IF OldDate THEN
        SetFTime(DestFile,FileTime);
      Close(DestFile);
      IF NOT NewFile THEN BEGIN
        ERASE(SrcFile);
        RENAME(DestFile,FName);
      END;
    END
  ELSE
    Writeln('File error with file ',DFName);
END;  { DoEnTab }

PROCEDURE ProcessThisFile(FileInfo:SearchRec);
BEGIN
  WITH FileInfo DO BEGIN
    Write(CurrentPath);
    Write(FixString(Name,12),' ');
    DoEnTab(Name);
    IF Modified THEN
      Writeln('  modified')
    ELSE
      Writeln;
  END;
END;  { ProcessThisFile }

BEGIN
  Writeln('File Space to Tab/Tab to Space Program by B Whitnall, V2.0');
  OptionString:='';
  FileSpec:='*.ASM';
  IF ParamCount > 0 THEN FOR I:=1 TO ParamCount DO BEGIN
    TextLine:=UpperCase(ParamStr(I));
    IF TextLine[1] = '/' THEN
      OptionString:=OptionString + TextLine
    ELSE BEGIN
      IF I = 1 THEN
        FileSpec:=TextLine;
    END;
  END;
  IF FileSpec = '?' THEN ShowHelp;
  I:=POS(':',FileSpec);
  IF I = 0 THEN
    BEGIN
      ChosenDrive:='';
      DriveNum:=0;
    END
  ELSE BEGIN
    ChosenDrive:=COPY(FileSpec,1,I);
    DriveNum:=ORD(UpCase(ChosenDrive[1]))-$40;
    IF Length(FileSpec) = I THEN
      FileSpec:=FileSpec+'*.ASM';
  END;
(*  IF POS(':',FileSpec) > 0 THEN BEGIN
    Writeln('Warning - Drive specification not supported.');
    HALT;
  END;*)
  IF POS('\',FileSpec) > 0 THEN BEGIN
    Writeln('Warning - Path specification not supported.');
    HALT;
  END;
  I:=POS('.',FileSpec);
  IF I = 0 THEN
    BEGIN
      Writeln('Warning - No File Extension specified.');
      HALT;
    END
  ELSE
    FileExt:=COPY(FileSpec,I+1,3);
  ProcessOptions;
  GetDir(0,OriginalPath);
  ChDir(ChosenDrive);
  GetDir(DriveNum,CurrentPath);
  IF CurrentPath[Length(CurrentPath)] <> '\' THEN
    CurrentPath:=CurrentPath+'\';
  FindFirst(FileSpec,Archive,FindRec);
  WHILE DosError=0 DO BEGIN
    ProcessThisFile(FindRec);
    FindNext(FindRec);
  END;
  ChDir(OriginalPath);
END.
